/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1201.mixin.client;

import com.mojang.blaze3d.vertex.PoseStack;
import mcinterface1201.InterfaceRender;
import mcinterface1201.WrapperEntity;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.RotationMatrix;
import minecrafttransportsimulator.baseclasses.TransformationMatrix;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.entities.instances.EntityPlayerGun;
import minecrafttransportsimulator.entities.instances.PartSeat;
import minecrafttransportsimulator.jsondefs.JSONPart;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4fc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntityRenderer.class})
public abstract class LivingEntityRendererMixin<T extends LivingEntity> {
    private static boolean needToRestoreState = false;
    private static ItemStack heldStackHolder = null;
    private static final Point3D entityScale = new Point3D();
    private static final RotationMatrix riderBodyOrientation = new RotationMatrix();
    private static float riderStoredHeadRot;
    private static float riderStoredHeadRotO;
    private static final TransformationMatrix riderTotalTransformation;
    private static float lastRiderPitch;
    private static float lastRiderPrevPitch;

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;pushPose()V")})
    public void inject_renderPre(T pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, CallbackInfo ci) {
        EntityPlayerGun gunEntity;
        WrapperEntity entityWrapper = WrapperEntity.getWrapperFor(pEntity);
        AEntityB_Existing ridingEntity = entityWrapper.getEntityRiding();
        if (ridingEntity != null) {
            ridingEntity.getInterpolatedOrientation(riderBodyOrientation, pPartialTicks);
            riderBodyOrientation.convertToAngles();
            if (ridingEntity instanceof PartSeat) {
                PartSeat seat = (PartSeat)ridingEntity;
                entityScale.set(seat.riderScale);
                if (((JSONPart)seat.definition).seat.playerScale != null) {
                    entityScale.multiply(((JSONPart)seat.definition).seat.playerScale);
                }
                if (seat.placementDefinition.playerScale != null) {
                    entityScale.multiply(seat.placementDefinition.playerScale);
                }
            } else {
                entityScale.set(1.0, 1.0, 1.0);
            }
            riderStoredHeadRot = ((LivingEntity)pEntity).f_20885_;
            riderStoredHeadRotO = ((LivingEntity)pEntity).f_20886_;
            lastRiderPitch = pEntity.m_146909_();
            lastRiderPrevPitch = ((LivingEntity)pEntity).f_19860_;
            ((LivingEntity)pEntity).f_20886_ = ((LivingEntity)pEntity).f_20885_ = (float)(-ridingEntity.riderRelativeOrientation.convertToAngles().y);
            pEntity.m_146926_((float)ridingEntity.riderRelativeOrientation.angles.x);
            ((LivingEntity)pEntity).f_19860_ = pEntity.m_146909_();
            ((LivingEntity)pEntity).f_20883_ = 0.0f;
            ((LivingEntity)pEntity).f_20884_ = 0.0f;
            LocalPlayer cameraEntity = Minecraft.m_91087_().f_91074_;
            if (cameraEntity != null) {
                Vec3 cameraEntityPos = cameraEntity.m_20182_();
                Vec3 entityPos = pEntity.m_20182_();
                new Point3D(((LivingEntity)pEntity).f_19854_ - cameraEntity.f_19854_ + (entityPos.f_82479_ - ((LivingEntity)pEntity).f_19854_ - (cameraEntityPos.f_82479_ - cameraEntity.f_19854_)) * (double)pPartialTicks, ((LivingEntity)pEntity).f_19855_ - cameraEntity.f_19855_ + (entityPos.f_82480_ - ((LivingEntity)pEntity).f_19855_ - (cameraEntityPos.f_82480_ - cameraEntity.f_19855_)) * (double)pPartialTicks, ((LivingEntity)pEntity).f_19856_ - cameraEntity.f_19856_ + (entityPos.f_82481_ - ((LivingEntity)pEntity).f_19856_ - (cameraEntityPos.f_82481_ - cameraEntity.f_19856_)) * (double)pPartialTicks);
                riderTotalTransformation.resetTransforms();
                riderTotalTransformation.applyTranslation(0.0, -entityWrapper.getSeatOffset(), 0.0);
                riderTotalTransformation.applyRotation(riderBodyOrientation);
                riderTotalTransformation.applyScaling(entityScale);
                riderTotalTransformation.applyTranslation(0.0, entityWrapper.getSeatOffset(), 0.0);
                pMatrixStack.m_85850_().m_252922_().mul((Matrix4fc)InterfaceRender.convertMatrix4f(riderTotalTransformation));
            }
            needToRestoreState = true;
        }
        if (pEntity instanceof Player && (gunEntity = EntityPlayerGun.playerClientGuns.get(pEntity.m_20148_())) != null && gunEntity.activeGun != null) {
            Player player = (Player)pEntity;
            heldStackHolder = player.m_21205_();
            player.m_150109_().m_6836_(player.m_150109_().f_35977_, ItemStack.f_41583_);
        }
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    public void inject_renderPost(T pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, CallbackInfo ci) {
        if (needToRestoreState) {
            ((LivingEntity)pEntity).f_20885_ = riderStoredHeadRot;
            ((LivingEntity)pEntity).f_20886_ = riderStoredHeadRotO;
            pEntity.m_146926_(lastRiderPitch);
            ((LivingEntity)pEntity).f_19860_ = lastRiderPrevPitch;
            needToRestoreState = false;
        }
        if (heldStackHolder != null) {
            Player player = (Player)pEntity;
            player.m_150109_().m_6836_(player.m_150109_().f_35977_, heldStackHolder);
            heldStackHolder = null;
        }
    }

    static {
        riderTotalTransformation = new TransformationMatrix();
    }
}

